from PIL import Image, ImageDraw

from centralized_verification.envs.utils import map_parser


def create_image(name):
    grid_posns, _, start_idx, end_idx = map_parser(f"maps/{name}.txt")
    width = max(p[0] for p in grid_posns) + 1
    height = max(p[1] for p in grid_posns) + 1
    i = Image.new("RGB", (width * 90 + 10, height * 90 + 10), (255, 255, 255))
    id = ImageDraw.Draw(i, "RGB")

    def drawxy(xy, outline, fill):
        x, y = xy
        id.rectangle(((x * 90, y * 90), (x * 90 + 100, y * 90 + 100)), fill, outline, width=10)

    for x, y in grid_posns:
        drawxy((x, y), (0, 0, 0), (255, 255, 255))

    drawxy(grid_posns[start_idx[0]], (0, 0, 0), (255, 0, 0))
    drawxy(grid_posns[start_idx[1]], (0, 0, 0), (0, 255, 0))
    i.save(f"maps/{name}.png")


if __name__ == '__main__':
    create_image("ISR")
    create_image("MIT")
    create_image("Pentagon")
    create_image("SUNY")
